/*  
 *
 *  JRacer
 *  Created by: Kyle, Aaron, Brad
 *  June 2005 (C)
 *  
 */
 
 // Game Imports
import java.awt.*;
import java.awt.event.*;
import java.awt.Image;
import java.util.*;
import javax.swing.*;
/* PLAYER
 *used to creat human and computer players
 *has a direction, coulor, coordinates, and lives
 *keeps track of direction and cooridinates on previous
 *
 *
 *
 *
 *
 *
 */

public class Player {  
	private String direction,direction2;
	private String tempdirection;
	private String coulor;
	private int x, y,x2,y2;
	private int tempx,tempy;
	private int up,left,right,down,jump;
	private boolean crash;
	private int player;
	private int lives;
	private boolean dead;
	private boolean AIjump;
	private int c;

	private String[] moveOrder;
	//sets players oringonal stats ie. lives, and which player it is
	public Player(int z){  
		moveOrder=new String[4];
		player=z;
		lives=5;
		dead=false;
		setPretty();//set the rest of players stats the first time
				
	}  
	//sets and resets players stats every new game 
	public void setPretty()
	{
		
		if(crash) lives--;	//if they crashed lose a life
		//**player 1**
		//sets direction, colour and controls
		if(player==1)
		{
			//if(Money.getP1()>0)lives=0; will be used to decide
			//one or two player based on wether money has been
			//inserted
			if(lives<=0) dead=true;
			coulor="red";
			if(dead)coulor="grey";
			direction="right";
			x=0;
			y=1;
			up=1;
			left=10;
			right=12;
			down=11;
			jump=0;	
		}
		//**player 2**
		//sets direction, colour and controls
		else if(player==2)
		{
			//if(Money.getP2()>0)lives=0;
			if(lives<=0) dead=true;
			coulor="blue";
			if(dead)coulor="grey";
			direction="left";
			x=31;
			y=23;
			up=4;     
			left=13; 
			right=15;
			down=14;
			jump=5;	
		}
		
		c=0;
		crash=false;  
		GamePanel.TM.setTile(x,y,coulor+direction+".png");
		//sets player the first time		
	}
	//returns player's lives
	public int getLives()
	{
		return(lives);
	}
		
	//returns player's x coordinate
	public int getX() 
	{
		return (x);
	}
	//returns player's y coordinate
	public int getY()
	{
		return(y);
	}
	//returns player's colour
	public String getCoulor(){
		
		return(coulor);
	}
	//returns player's direction
	public String getDirection()
	{
		return (direction);
	}
	//returns player's previous direction
	public String getTempDirection(){
		return(tempdirection);
	}
	//returns player's previous x coordinate
	public int getTempX(){
		return(tempx);
	}
	//returns player's previous y coordinate
	public int getTempY(){
		return(tempy);
	}
	//returns true if player has crashed
	public boolean getCrash(){
		return(crash);
	}
	//returns true if players dead
	public boolean getDead()
	{
		return(dead);
	}
	
	
	//**changes player's direction based on key input
	//up, down, left or right
	public void changeDirection(){  
		tempdirection=direction;
		if(GamePanel.buttons[up]) {
			direction="up";
			
		}
		else if(GamePanel.buttons[left]) {
			direction="left";
			
		}
		else if(GamePanel.buttons[right]) {
			direction="right";
		
		}
		else if(GamePanel.buttons[down]) {
			direction="down";
			
		}	
	}
	//**checks if the player has crashed
	public boolean checkCrash(int x, int y){  //Checks if users hit side of walls
		
		if (x<0||x>31||y<1||y>23){          //Check if user hits side of screen	
			return(true);	//Yes they crashed
		} 
		
		if(GamePanel.TM.getTile(x,y).equals("blank.png"))  //Check to see if user is still alive
		{
			return(false);	 //no they havent crashed
		} 
		
		else
		{
			return(true); //the tile isn't blank, so they have crashed
		} 
	}  
	//the AI for the computer player
	public void AI()
	{	
		
		c++;//used to make the player jump and change direction 
			//at regular intervals	
		AIjump=false;//the AI won't jump
		tempdirection=direction;//keep track of old direction
								//so that trail can be drawn
								//the same way players is 
								
		//***   gets other players position and direction  						
		if(player==1)				
		{									
			x2=GamePanel.P2.getX();				
			y2=GamePanel.P2.getY();					
			direction2=GamePanel.P2.getDirection(); 
		}
		if(player==2)
		{
			x2=GamePanel.P1.getX();
			y2=GamePanel.P1.getY();
			direction2=GamePanel.P1.getDirection();
		}
		
		/***** how the AI works ****
		 *uses a slightly different algorythm depending on where
		 *it's starting, so as to not check a dumb direction at
		 *beginning of the game
		 *
		 *if the player is closer vertically or horizontally it will
		 *then check if its above/below or left/right and try to move
		 *there first
		 *
		 *every fifth move it will go to the go horizontally if the
		 *the player is closer vertically
		 *
		 *
		 */
		if(player==1)
		{
			if(Math.abs(y-y2)>Math.abs(x-x2)||c%5==0)//the player is futher verticaly
			{	
				if((y-y2)>0)//player is above
				{
					if(check("up")) direction="up";
					else if(check("right")) direction="right";
					else if(check("left")) direction="left";
					else if(check("down")) direction="down";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}
				if((y-y2)<0)//player is below
				{
					if(check("down")) direction="down";
					else if(check("right")) direction="right";
					else if(check("left")) direction="left";
					else if(check("up")) direction="up";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}
			}	
			else//the player is further horizontally
			{
				if((x-x2)>0)//player if on left
				{
					if(check("left")) direction="left";
					else if(check("down")) direction="down";	
					else if(check("up")) direction="up";
					else if(check("right")) direction="right";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}
				else
				{
					if((x-x2)<0)//player is on right
					{
						if(check("right")) direction="right"; 
						else if(check("down")) direction="down";
						else if(check("up")) direction="up";
						else if(check("left")) direction="left";
						else 
						{
							jump();
							GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
						}
				
					}
				}
			}
		}	
		else if(player==2)
		{		
			if(Math.abs(y-y2)>Math.abs(x-x2))//the player is futher verticaly
			{	
				if((y-y2)>0)//player is above
				{
					if(check("up")) direction="up";
					else if(check("left")) direction="left";
					else if(check("right")) direction="right";
					else if(check("down")) direction="down";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}
				if((y-y2)<0)//player is below
				{
					if(check("down")) direction="down";
					else if(check("left")) direction="left";
					else if(check("right")) direction="right";
					else if(check("up")) direction="up";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}
			}
			else//the player is further horizontally
			{
				if((x-x2)>0)//player if on left
				{
					if(check("left")) direction="left";
					else if(check("up")) direction="up";
					else if(check("down")) direction="down";	
					else if(check("right")) direction="right";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}
				if((x-x2)<0)//player is on right
				{
					if(check("right")) direction="right"; 
					else if(check("up")) direction="up";
					else if(check("down")) direction="down";
					else if(check("left")) direction="left";
					else 
					{
						jump();
						GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");
					}
				}	
			}
		}
		if(tempdirection==direction)
		{
			if(checkJump(direction)&&c%GamePanel.level==0) AIjump=true;	
		}		
	} //end of AI
	
	
	public boolean check(String dir)
	{
		
		if(dir=="up")
		{
			return(checkUp());
		}	
		else if(dir=="left")
		{
			return(checkLeft());
		}	
		else if(dir=="down")
		{
			return(checkDown());
		}	
		else if(dir=="right")
		{
			return(checkRight());
		}
		return true;
	}

	public boolean checkJump(String dir)
	{
		
		if(dir=="up")
		{
			return(checkUpJump());
		}	
		else if(dir=="left")
		{
			return(checkLeftJump());
		}	
		else if(dir=="down")
		{
			return(checkDownJump());
		}	
		else if(dir=="right")
		{
			return(checkRightJump());
		}
		return true;
	}
	
	
	public boolean checkUp()
	{
		if(y>2)
		{
			if(GamePanel.TM.getTile(x,(y-1)).equals("blank.png")&&tempdirection!="down")
			{
				if(GamePanel.TM.getTile((x),(y-2)).equals("blank.png")||GamePanel.TM.getTile((x-1),(y-1)).equals("blank.png")||GamePanel.TM.getTile((x+1),(y-1)).equals("blank.png"))
				{
					return(true);	
				}		
			}
		}
		return(false);
	}
	public boolean checkUpJump()
	{
		if(y>3)
		{
			if(GamePanel.TM.getTile(x,(y-2)).equals("blank.png")&&tempdirection!="down")
			{
				if(GamePanel.TM.getTile((x),(y-3)).equals("blank.png")||GamePanel.TM.getTile((x-1),(y-2)).equals("blank.png")||GamePanel.TM.getTile((x+1),(y-3)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}
		return(false);
	}
	public boolean checkRight()
	{
		if(x<29)
		{
			if(GamePanel.TM.getTile((x+1),y).equals("blank.png")&&tempdirection!="left")
			{
				if(GamePanel.TM.getTile((x+2),(y)).equals("blank.png")||GamePanel.TM.getTile((x+1),(y-1)).equals("blank.png")||GamePanel.TM.getTile((x+1),(y+1)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}
		return(false);
	}
	public boolean checkRightJump()
	{
		if(x<28)
		{
			if(GamePanel.TM.getTile((x+2),y).equals("blank.png")&&tempdirection!="left")
			{
				if(GamePanel.TM.getTile((x+3),(y)).equals("blank.png")||GamePanel.TM.getTile((x+2),(y-1)).equals("blank.png")||GamePanel.TM.getTile((x+2),(y+1)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}
		return(false);
	}
	public boolean checkDown()
	{
		if(y<21)
		{
			if(GamePanel.TM.getTile(x,(y+1)).equals("blank.png")&&tempdirection!="up")
			{
				if(GamePanel.TM.getTile((x),(y+2)).equals("blank.png")||GamePanel.TM.getTile((x-1),(y+1)).equals("blank.png")||GamePanel.TM.getTile((x+1),(y+1)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}
		return(false);
	}
	public boolean checkDownJump()
	{
		if(y<20)
		{
			if(GamePanel.TM.getTile(x,(y+2)).equals("blank.png")&&tempdirection!="up")
			{
				if(GamePanel.TM.getTile((x),(y+3)).equals("blank.png")||GamePanel.TM.getTile((x-1),(y+2)).equals("blank.png")||GamePanel.TM.getTile((x+1),(y+2)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}
		return(false);
	}
	public boolean checkLeft()
	{	
		if(x>1)
		{
			if(GamePanel.TM.getTile((x-1),y).equals("blank.png")&&tempdirection!="right")
			{
				if(GamePanel.TM.getTile((x-2),(y)).equals("blank.png")||GamePanel.TM.getTile((x-1),(y-1)).equals("blank.png")||GamePanel.TM.getTile((x-1),(y+1)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}	
		return(false);		
	}
	public boolean checkLeftJump()
	{	
		if(x>2)
		{
			if(GamePanel.TM.getTile((x-2),y).equals("blank.png")&&tempdirection!="right")
			{
				if(GamePanel.TM.getTile((x-3),(y)).equals("blank.png")||GamePanel.TM.getTile((x-2),(y-1)).equals("blank.png")||GamePanel.TM.getTile((x-2),(y+1)).equals("blank.png"))
				{
					return(true);	
				}	
			}
		}	
		return(false);		
	}
	
		
    public void move(){  //Move the player with right keypress
    	if(dead)
    	{
    		System.out.println("entered move");
    		AI();	
    	}
    	else
    	{
    		changeDirection();
    	}
    	tempx=x;
    	tempy=y;
    	if(!dead)
    	{
    		if(direction.equals("up")) {   //User pressed up key change direction to up
    		crash=checkCrash(x,(y-1)); //Check if user crashed
    		if(!crash) y=y-1;  //If they havent crashed then keep moving
    	}
    	if(direction.equals("left")) {  //User pressed left key, change direction to left
    		crash=checkCrash((x-1),y);  //Check if user crashed
    		if(!crash) x=x-1;  //If user didnt crash continue moving
    	}
    	if(direction.equals("right")) {  //User pressed right key, change direction to right   		
    		crash=checkCrash((x+1),y);  //Check if user crashed
    		if(!crash) x=x+1;	 //If user didnt crash continue moving	
    	}
    	if(direction.equals("down")) {  //User pressed down key, change direction to down
    		crash=checkCrash(x,(y+1));  //Check if user crashed
    		if(!crash) y=y+1;   //If user didnt crash continue moving
    	}		
    	
    	}
    	else
    	{
    	
    		if(AIjump) jump();
    		else
    		{
    		
    			if(direction.equals("up")) {   //User pressed up key change direction to up
    				crash=checkCrash(x,(y-1)); //Check if user crashed
    				if(!crash) y=y-1;  //If they havent crashed then keep moving
    			}
    			if(direction.equals("left")) {  //User pressed left key, change direction to left
    				crash=checkCrash((x-1),y);  //Check if user crashed
    				if(!crash) x=x-1;  //If user didnt crash continue moving
    			}
    			if(direction.equals("right")) {  //User pressed right key, change direction to right   		
    				crash=checkCrash((x+1),y);  //Check if user crashed
    				if(!crash) x=x+1;	 //If user didnt crash continue moving	
    		}
    			if(direction.equals("down")) {  //User pressed down key, change direction to down
    				crash=checkCrash(x,(y+1));  //Check if user crashed
    				if(!crash) y=y+1;   //If user didnt crash continue moving
    			}
    		}
    	}			
    	
   	}  //End Move 
   	
   	public void jump()
   	{	
   		tempdirection=direction;
   		tempx=x;
    	tempy=y;
   		if(direction.equals("up")) {   //User pressed up key change direction to up
    		crash=checkCrash(x,(y-2)); //Check if user crashed
    		if(!crash) y=y-2;  //If they havent crashed then keep moving
    	}
    	if(direction.equals("left")) {  //User pressed left key, change direction to left
    		crash=checkCrash((x-2),y);  //Check if user crashed
    		if(!crash) x=x-2;  //If user didnt crash continue moving
    	}
    	if(direction.equals("right")) {  //User pressed right key, change direction to right   		
    		crash=checkCrash((x+2),y);  //Check if user crashed
    		if(!crash) x=x+2;	 //If user didnt crash continue moving	
    	}
    	if(direction.equals("down")) {  //User pressed down key, change direction to down
    		crash=checkCrash(x,(y+2));  //Check if user crashed
    		if(!crash) y=y+2;   //If user didnt crash continue moving
    	}
    	GamePanel.TM.setTile(tempx,tempy,tempdirection+".png");			
   	}	
}  //End Player Class
		