import java.io.*;
import javax.swing.*;
import javax.sound.sampled.AudioFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

import com.brackeen.javagamebook.sound.*;
import com.brackeen.javagamebook.test.GameCore;


// This class is for testing purposes only.
class SoundTest
{
	public static PlaySound sound1;
	public static PlaySound sound2;
	public static void main (String args[]) throws Exception
	{
		InputStreamReader isr = new InputStreamReader(System.in);
		BufferedReader br = new BufferedReader (isr);
		
		sound1 = new PlaySound("../sounds/boop.wav");
		sound2 = new PlaySound("../sounds/fly-bzz.wav");
		sound1.play();
		sound2.loop();
		String input=br.readLine();
		sound1.stop();
		sound2.stop();
		input=br.readLine();
		sound2.play();
		sound1.loop();
		input=br.readLine();
		sound1.close();
		sound2.close();
	}

}

// Sound playing simplified.
class PlaySound
{
	private static final AudioFormat PLAYBACK_FORMAT = new AudioFormat(44100, 16, 1, true, false);
	private SoundManager soundManager;
   	private Sound s;
   	private InputStream lastloopingSound;
   	private boolean p;
	
	public PlaySound(String fileLoc)
	{
        soundManager = new SoundManager(PLAYBACK_FORMAT);
        s = soundManager.getSound(fileLoc);
        p = false;
	}
	
	public void play()
	{   		
   		if (p)
   		{
   			soundManager.setPaused(false);
   			p = false;
   		}
   		else 
   			soundManager.play(s);
	}
	
	public void loop()
	{
		soundManager.play(s,null,true);
	}
	
	public void stop()
	{
		soundManager.setPaused(true);
		p=true;
	}
	
	public void close()
	{
		soundManager.close();
	}
	
	
}