import java.io.*;
import java.awt.*;
import javax.swing.*;
class FileMenu
{
	private int totalGames; // number of games installed
	
	// Default constructor gets the number of installed games.
	public FileMenu()
	{
		totalGames=1;
		setTotalGames();	
	}
	

	// Finds how many games are installed based on finding each game's highscore.txt file
	public void setTotalGames()
	{
		FileReader fr;
		while (true)
		{
			try{
				fr = new FileReader("game"+totalGames+"/highscore.txt");
			}
			catch (FileNotFoundException e)
			{
				break;
			}
			totalGames++;
		}
	}	
	
	// returns totalGames
	public int getTotalGames()
	{
		return totalGames-1;
	}
	
	public void runGame (int gn)
	{
		/*
		 *Jpanel game = new ;
		 *
		 *
		 *
		 */		
	}
/*
	public Image getBlackImage(int gn)
	{
		return (new Image("game"+gn+"/black.gif"));
	}
	
	public Image getColorImage(int gn)
	{
		Image temp= new Image("game"+gn+"/color.gif");
		return (temp);
	}
*/	
	
// ####################   getHighScore   ##########################
	/*
	 *Purpose: This method reads the high score file and returns it to
	 *			the caller.
	 *
	 *Input: gn represents the game number.
	 *
	 *Output: An array of strings where each string is a high score.
	 *			The array starts with the highest score in position zero.
	 */
	public String [] getHighScore(int gn)
	{
		FileReader fr;
		BufferedReader br;
		final int numberOfHighScores = 10; //Constant for the total number of high scores per game.
		String [] hs = new String [numberOfHighScores]; //The array that will be returned
		String temp;
		
		int lineCnt = 0;//Counts each high score as it is read
				
		// OPEN THE FILE
		try{
			fr = new FileReader("game"+gn+"/highscore.txt");
		}
		// Print an error to the console and return an error array
		catch (FileNotFoundException e)
		{
			return (hs=fileError(1, e));
		}
		br= new BufferedReader (fr);	
		
		// READ THE FILE
		// reads each line of the file
		while (lineCnt<numberOfHighScores)
		{
			try{
				temp = br.readLine();
			}
			// Print an error to the console and return an error array
			catch (IOException e)
			{
				return (hs=fileError(2, e));
			}
			
			hs[lineCnt++]=temp;
				
		}
		
		// CLOSE THE FILE
		try{
			br.close();
		}
		catch (IOException e)
		{
			return (hs=fileError(3, e));
		}
		
		return hs;
		
	}
	
// ####################   fileError   #####################
	/*
	 *Purpose: 	This method is a companion for getHighScore.
	 *			It handles errors for getHighScore.
	 *
	 *Input: 	int errorNum 	-- errorNum represents where in getHighScore the error
	 *							occured.
	 *			Exception e		-- The error that occured
	 *
	 *Output:	A string array.  This is an error array to return to getHighScore
	 *			that is subsiquently returned by getHighScore.
	 *
	 */
	private String [] fileError (int errorNum, Exception e)
	{
		String [] error = new String [1];
		error[0]="ERROR";
		System.out.println("ERROR in FileMenu "+errorNum+ ": " +e);
		return error;
	}

	
	public void playIntro(int gn)
	{
		
	}
	
}