import javax.swing.*;  
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import com.brackeen.javagamebook.sound.*;
import com.brackeen.javagamebook.test.GameCore;


public class useGame {
	private static String path;
	public static void main(String [] args){
		JFrame j=new JFrame();
		j.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		j.getContentPane().add(new KeypressPanel(path), BorderLayout.CENTER);
		j.setSize(800,600);
		//j.pack();
		j.setVisible(true);
	}
	public void setPath(String p)
	{
		path=p;	
	}
}


class KeypressPanel extends JPanel implements KeyListener, ActionListener {


	double tx;
	double ty;
	String path; // path to the game's folder.
	
	int tempx=0;
	
	dot[] d = new dot[80];
	bullet[] b =new bullet[200];
	player[] p={new player(),new player()};
	power[] pup=new power[3];
	int bgy=-1200;
	
	int playnum=2;
	int activedot=6;
	int wavenum=1;
	
	int flip=1;
		
	Timer time;
	
	private Image sprite;
	public static PlaySound sound1;
	public static PlaySound sound2;
	public static PlaySound sound3;
	
	private Image loadImage(String fileName) {
        return new ImageIcon(fileName).getImage();
    }

    public void drawImage(Graphics g, Image image, int x, int y, String caption)
    {
        g.drawImage(image, x, y, null);
    }
	public void spawn (int c)
	{
		d[c]=new dot();
			tempx=MyLib.randomInt(4);
			if (tempx==1)
				d[c].type=1;
			else
				d[c].type=0;	
				
			if (d[c].type==0)		
				fighter(c);
			else if (d[c].type==1)
				destroyer(c);
	}
	public void fighter(int x)
	{
		d[x].size=40;
		d[x].yv=10;
		d[x].x=x*d[x].size+20;
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=100+MyLib.randomInt(7)*100;
		d[x].life=2;
	}
	public void destroyer(int x)
	{
		d[x].size=80;
		d[x].yv=5;
		d[x].x=x*d[x].size+20;	
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=100+MyLib.randomInt(7)*100;
		d[x].life=5;
	}
	
	public KeypressPanel(String pa)
	{
		path = pa;
		sound1 = new PlaySound(path+"explosion1.wav");
		sound2 = new PlaySound("mus.wav");
		sound3 = new PlaySound("laser.wav");
		//sound2.loop();
		for (int c=0; c<activedot;c++)
		{
			spawn(c);	
		}

		for (int c=0; c<3;c++)
			pup[c]=new power();
		
		for (int i=0;i<2;i++)
		{
			for (int c=0; c<50;c++)
				p[i].b[c]=new bullet();	
		}
		for (int i=0; i<200;i++)
				b[i]=new bullet();	
		
		setBackground(Color.black);
		addKeyListener(this);
		time = new Timer(40, this);
		time.start();
		p[1].x=200;
		p[0].y=500;
		p[0].x=500;
		p[1].y=500;
	}
	
	
	////////////////////////paint stuff//////////////////////
	
	
	

	public void paintComponent(Graphics g){
		super.paintComponent(g);
		{
			flip++;
			sprite = loadImage("game1/sandtexture.png");
			g.drawImage(sprite, 0, bgy, 1024, 2030, this);
			bgy+=3;
			
					
			if (flip%150==0)
			{
				pup[0].active=true;	
				pup[0].y=-10;
			}
			if (pup[0].active)
			{
				pup[0].y+=8;
				g.setColor(Color.cyan);
				g.fillOval(pup[0].x,pup[0].y, 35, 35);
				
			}
			if (pup[0].y>768)
				pup[0].active=false;
				

					
			
			
			//sprite = loadImage("clouds2.png");
			//	g.drawImage(sprite, 0, 400+bgy/2, 800,600, this);
		/*		
		sprite = loadImage("clouds2.png");
			g.drawImage(sprite, 200, 200, 70, 70, this);
		sprite = loadImage("clouds3.png");
			g.drawImage(sprite, 300, 300, 70, 70, this);
		sprite = loadImage("clouds4.png");
			g.drawImage(sprite, 400, 400, 70, 70, this);*/
			
			if (bgy==0)
				bgy=-1200;
			
			for (int i=0;i<200;i++)
			{
				b[i].x+=b[i].xv;
				b[i].y+=b[i].yv;
			}
			for (int c=0;c<activedot;c++)
			{
				
								
				if (d[c].type==2&&d[c].x>675||d[c].x<50)
					d[c].xv*=-1;
				
				if (d[c].active&&d[c].y>768)
				{
					d[c].active=false;
					spawn(c);
				}
				if (d[c].active==true)
				{
					d[c].y+=d[c].yv;
					d[c].x+=d[c].xv;

					if (d[c].type==0)
						sprite = loadImage("enemyfin.png");
					else if (d[c].type==1)
						sprite = loadImage("destroyer.png");
					else if (d[c].type==2)
						sprite = loadImage("boss1.png");
							

					g.drawImage(sprite, d[c].x, d[c].y, d[c].size, d[c].size, this);	
				}	
			}
			
			
			for (int c=0;c<playnum;c++)
			{
				
				p[c].inv--;
				
				if (pup[0].active&&p[c].alive&&p[c].x>pup[0].x-35&&p[c].x<pup[0].x+35&&p[c].y+35>pup[0].y&&p[c].y-35<pup[0].y)
				{
					p[c].power+=1;	
					pup[0].active=false;
				}
				
				if (c==0)
				{
					if(p[c].left)	
						sprite = loadImage("player1left.png");
					else if (p[c].right)
						sprite = loadImage("player1right.png");
					else
						sprite = loadImage("player1fin.png");	
				}
				else
				{
					if (p[c].left)	
						sprite = loadImage("player2left.png");
					else if (p[c].right)
						sprite = loadImage("player2right.png");
					else
						sprite = loadImage("player2fin.png");
				}
				
				if (p[c].inv>1)
				{
					g.setColor(Color.green);
					g.fillOval(p[c].x,p[c].y, 55, 55);
				}
					
				if (p[c].alive)
					g.drawImage(sprite, p[c].x, p[c].y, 55, 55, this);
					
				
				for (int i=0;i<200;i++)
				{
					if (b[i].active)
					{
						g.setColor(Color.blue);
						g.fillOval(b[i].x,b[i].y, b[i].size, b[i].size*5);
					}
					if (p[c].inv<1&&(b[i].active&&p[c].alive&&p[c].x-b[i].size<b[i].x&&p[c].x+50>b[i].x)&&(p[c].y-b[i].size<b[i].y&&p[c].y+50>b[i].y))
					{
							if (p[c].lives>0)
							{
								p[c].lives--;
								b[i].active=false;	
								p[c].inv=35;
								p[c].power=1;
								//sound1.play();
							}
							else
								p[c].alive=false;
					}
				}
					
				for (int i=0;i<30;i++)
				{
					p[c].b[i].y-=15;
					if (p[c].b[i].y<0)
						p[c].b[i].active=false;
					for (int j=0;j<activedot;j++)
					{
						if (p[c].b[i].active&&d[j].active&&(p[c].b[i].x+p[c].b[i].size>d[j].x&&p[c].b[i].x<d[j].x+d[j].size)&&(p[c].b[i].y+p[c].b[i].size>d[j].y&&p[c].b[i].y<d[j].y+d[j].size-p[c].b[i].size*2))
						{
							sprite = loadImage("explode.png");
							g.drawImage(sprite, p[c].b[i].x, p[c].b[i].y, 25, 25, this);
							p[c].b[i].active=false;
							d[j].life--;
							if (d[j].life<1)
							{
								d[j].active=false;
								p[c].score++;
								sprite = loadImage("explode.png");
								g.drawImage(sprite, d[j].x, d[j].y,d[j].size, d[j].size, this);
								//spawn(j);
							}																	
						}
					}
					if (p[c].b[i].active)
					{
						g.setColor(Color.red);
						g.fillOval(p[c].b[i].x,p[c].b[i].y, p[c].b[i].size, p[c].b[i].size*5);
					}
				}	
			}
			

		}
		if (p[0].alive)
			p[0].score++;
		if (p[1].alive)
			p[1].score++;

				
		g.setColor(Color.black);
		
		g.drawString("Player 1 Score:"+p[0].score*100,15,15);
		g.drawString("Player 1 Lives:"+p[0].lives,15,30);
		g.drawString("Player 2 Score:"+p[1].score*100,650,15);
		g.drawString("Player 2 Lives:"+p[1].lives,650,30);
		requestFocus();
	}
	
	
	
	
	//////////////////////action stuff//////////////////////////
	
	

	public void actionPerformed(ActionEvent e)
	{ 
		for (int c=0;c<activedot;c++)
		{
			tempx=MyLib.randomInt(1+1);
			for (int j=0;j<200;j++)
			{
				if (d[c].type==0&d[c].active==true&&b[j].active==false&&flip%21==0)
				{	
						b[j].size=5;
						b[j].active=true;
						b[j].y=d[c].y+d[c].size/2;
						b[j].x=d[c].x+d[c].size/2;
						b[j].xv=0;
						b[j].yv=15;
						break;
				}
				else if (d[c].type==1&&d[c].active==true&&flip%30==0&&b[j].active==false)
				{
					b[j].active=true;
					b[j].x=d[c].x+d[c].size/2;
					b[j].y=d[c].y+d[c].size/2;
					b[j].xv=0;
					b[j].yv=25;
					b[j].size=15;
					break;
				}
				else if (d[c].type==2&&d[c].active==true&&flip%10==0&&b[j].active==false)
				{
					b[j].active=true;
					b[j].x=d[c].x+d[c].size/2;
					b[j].y=d[c].y+d[c].size/2;
					b[j].xv=15-MyLib.randomInt(30);
					b[j].yv=23;	
					b[j].size=10;
					break;
				}
			if (b[j].y>768)
				b[j].active=false;
			}
		}
			
		for(int i=0;i<playnum;i++)
		{	
			p[i].time++;		
			if (p[i].alive==true)
			{		
				if (p[i].left==true&&p[i].x>10)
					p[i].x=p[i].x-10;
				else if(p[i].right==true&&p[i].x<750)
					p[i].x=p[i].x+10;
				if (p[i].up==true&&p[i].y>10)
					p[i].y=p[i].y-10;
				else if(p[i].down==true&&p[i].y<500)
					p[i].y=p[i].y+10;
			}
			
			if (p[i].fire==true)
			{
				for(int r=1;r<=p[i].power;r++)
				{
					for (int c=0;c<30;c++)
					{
						if (p[i].b[c].active==false&&flip%10>3)
						{
							p[i].b[c].active=true;
							
							if (p[i].power==1)
							{
								p[i].b[c].x=p[i].x+25;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==2&&r==1)
							{
								p[i].b[c].x=p[i].x+16;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==2&&r==2)
							{
								p[i].b[c].x=p[i].x+32;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==3&&r==1)
							{
								p[i].b[c].x=p[i].x+15;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==3&&r==2)
							{
								p[i].b[c].x=p[i].x+25;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==3&&r==3)
							{
								p[i].b[c].x=p[i].x+35;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==1)
							{
								p[i].b[c].x=p[i].x+8;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==2)
							{
								p[i].b[c].x=p[i].x+16;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==3)
							{
								p[i].b[c].x=p[i].x+33;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==4)
							{
								p[i].b[c].x=p[i].x+42;
								p[i].b[c].y=p[i].y-20;
							}
							
							
							p[i].b[c].yv=-25;
							p[i].b[c].xv=0;	
							//sound3.play();
							break;
						}
					}
				}
				p[i].fire=false;
			}
			
				
			}
					
		repaint();
	}
	
	
	/////////////////////////key stuff////////////////////////
	
	
	public void keyPressed(KeyEvent e){
		if (e.getKeyChar() == 'a') {
			p[0].left=true;
			p[0].right=false;
		}
		if (e.getKeyChar() == 'd') {
			p[0].right=true;
			p[0].left=false;
		}
		if (e.getKeyChar() == 'w') {
			p[0].up=true;
			p[0].down=false;
		}
		if (e.getKeyChar() == 's') {
			p[0].down=true;
			p[0].up=false;
		}
		if (e.getKeyChar() == 'b'&&p[0].alive==true) {
			p[0].fire=true;
		}
		
		if (e.getKeyChar() =='1') {
			p[1].left=true;
			p[1].right=false;
		}
		if (e.getKeyChar() == '3') {
			p[1].right=true;
			p[1].left=false;
		}
		if (e.getKeyChar() == '5') {
			p[1].up=true;
			p[1].down=false;
		}
		if (e.getKeyChar() == '2') {
			p[1].down=true;
			p[1].up=false;
		}
		if (e.getKeyChar() == ']'&&p[1].alive==true) {
			p[1].fire=true;
		}


	}
	public void keyReleased(KeyEvent e){ 
		if (e.getKeyChar() == 'a') {
			p[0].left=false;
		}
		if (e.getKeyChar() == 'd') {
			p[0].right=false;
		}
		if (e.getKeyChar() == 'w') {
			p[0].up=false;
		}
		if (e.getKeyChar() == 's') {
			p[0].down=false;
		}
		
		if (e.getKeyChar() == '1') {
			p[1].left=false;
		}
		if (e.getKeyChar() == '3') {
			p[1].right=false;
		}
		if (e.getKeyChar() == '5') {
			p[1].up=false;
		}
		if (e.getKeyChar() == '2') {
			p[1].down=false; 
		}
		
		
	}
	public void keyTyped(KeyEvent e)
	{ 
	}
}
