import javax.swing.*;  
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import com.brackeen.javagamebook.sound.*;
import com.brackeen.javagamebook.test.GameCore;


/*public class version1 {
	public static void main(String [] args){
		JFrame j=new JFrame();
		j.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		j.getContentPane().add(new KeypressPanel(), BorderLayout.CENTER);
		j.setSize(800,600);
		//j.pack();
		j.setVisible(true);
	}
}*/


class KeypressPanel extends JPanel implements KeyListener, ActionListener {


	int tx;
	boolean boss=false;
	boolean tempb=false;
	
	int tempx=0;
	
	dot[] d = new dot[30];
	bullet[] b =new bullet[200];
	explosion[] e=new explosion[200];
	player[] p={new player(),new player()};
	power pup=new power();
	int bgy=-600;
	int transy=-800;
	int cloudy=-600;
	
	int playnum=2;
	int activedot=3;
	int wavenum=1;
	
	int flip=1;
		
	Timer time;
	
	private Image sprite;
	public static PlaySound sound1;
	public static PlaySound sound2;
	public static PlaySound sound3;
	public static PlaySound sound4;
	
	private Image loadImage(String fileName) {
        return new ImageIcon(fileName).getImage();
    }

    public void drawImage(Graphics g, Image image, int x, int y, String caption)
    {
        g.drawImage(image, x, y, null);
    }
    
    // This method spawns enemies by creating/recreating the enemy objects
	public void spawn (int c)
	{
		//A new object is created, then its type determined based on the players progression through the game
		d[c]=new dot();
		if (flip<1900||(flip>2100&&flip<3900)||(flip>4100&&flip<7900))	
		{
			tempx=MyLib.randomInt(11);
			if (flip>6500&&tempx==10)
				d[c].type=4;
			else if (flip>4500&&(tempx==9||tempx==8))	
				d[c].type=3;
			else if (flip>2500&&(tempx==7||tempx==6))
				d[c].type=2;
			else if (flip>1500&&(tempx==5||tempx==4))	
				d[c].type=1;
			else 
				d[c].type=0;
			
					
			//when the ship type has been selected the respective method is
			//called to give the enemy object (dot, or d[c]) its attributes	
			if (d[c].type==0)		
				fighter(c);
			else if (d[c].type==1)
				destroyer(c);
			else if (d[c].type==2)
				hdestroyer(c);
			else if (d[c].type==3)
				crab(c);
			else if	(d[c].type==4)
				cruiser(c);	
		}
		// the following ifs spawn the bosses at their respective points in the game	
		else if (flip==2000) //boss 1
		{
			d[c].active=true;
			boss=true;
			activedot=1;
			d[c].type=10;
			d[c].x=-200;
			d[c].y=20;
			d[c].xsize=150;
			d[c].ysize=150;
			d[c].life=150;
			d[c].xv=7;
		}
		else if (flip==4000) //boss 2
		{
			d[c].active=true;
			boss=true;
			activedot=1;
			d[c].type=11;
			d[c].x=	-300;
			d[c].y=20;
			d[c].xsize=300;
			d[c].ysize=150;
			d[c].life=300;
			d[c].xv=7;
		}
		else if (flip==8000) //boss 3
		{
			d[c].active=true;
			boss=true;
			activedot=1;
			d[c].type=12;
			d[c].x=	-300;
			d[c].y=20;
			d[c].xsize=300;
			d[c].ysize=200;
			d[c].life=500;
			d[c].xv=3;
		}
	}
	
	//this method sets the atributes for the fighters
	public void fighter(int x)
	{
		d[x].xsize=40;
		d[x].ysize=40;
		d[x].yv=8;
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=MyLib.randomInt(690)+10;
		d[x].life=2;
		d[x].active=true;
	}
	
	//cruiser attributes
	public void cruiser(int x)
	{
		d[x].xsize=150;
		d[x].ysize=120;
		d[x].yv=3;
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=MyLib.randomInt(690)+10;
		d[x].life=12;
		d[x].active=true;
	}
	
	//crab ship attributes
	public void crab(int x)
	{
		d[x].xsize=50;
		d[x].ysize=50;
		d[x].yv=7;
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=MyLib.randomInt(690)+10;
		d[x].life=10;
		d[x].active=true;
	}
	
	//destroyer attributes
	public void destroyer(int x)
	{
		d[x].xsize=80;
		d[x].ysize=80;
		d[x].yv=5;
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=100+MyLib.randomInt(7)*100;
		d[x].life=5;
		d[x].active=true;
	}
	
	//heavy destroyer attributes
	public void hdestroyer(int x)
	{
		d[x].xsize=100;
		d[x].ysize=100;
		d[x].yv=4;	
		d[x].y=-50-(MyLib.randomInt(200));
		d[x].x=100+MyLib.randomInt(7)*100;
		d[x].life=8;
		d[x].active=true;
	}
	//this method is used for creating explosions
	// it finds the first empty spot in the explosion queue 
	// then creates one with the right coordinates and size
	public void explode (int x,int y,int xsize,int ysize)
	{
		for (int c=0;c<200;c++)
		{
			if (e[c].active==false)
			{
				e[c]=new explosion();
				e[c].x=x;
				e[c].y=y;
				e[c].xsize=xsize;
				e[c].ysize=ysize;
				e[c].active=true;
				break;
			}	
		}
	}
	
	//this initializes everything and gets the game going
	public KeypressPanel()
	{
		
		sound1 = new PlaySound("sounds/explosion1.wav");
		sound2 = new PlaySound("sounds/mus.wav");
		sound3 = new PlaySound("sounds/laser.wav");
		sound4 = new PlaySound("sounds/zap.wav");
		sound2.loop();
		for (int c=0; c<30;c++)
		{
			spawn(c);	
		}

		
		pup=new power();
		
		for (int i=0;i<2;i++)
		{
			for (int c=0; c<75;c++)
				p[i].b[c]=new bullet();	
		}
		for (int i=0; i<200;i++)
		{
			b[i]=new bullet();	
			e[i]=new explosion();
		}
		
		setBackground(Color.black);
		addKeyListener(this);
		time = new Timer(37, this);
		time.start();
		p[1].x=200;
		p[0].y=500;
		p[0].x=500;
		p[1].y=500;
		flip=0;
	}
	
	
	////////////////////////paint stuff//////////////////////
	
	
	

	public void paintComponent(Graphics g){
		super.paintComponent(g);
		{
			//flip is used to keep track of the players progression in the game
			// and time other things like when enemies spawn/attack
			flip++;
			System.out.println(flip);
			
			//the cloud's y coord is increased so they are slowing moving by
			cloudy+=5;
			
			//this is the backgrounds y coord and is increased for the scrolling effect
			bgy+=3;		

			//if a boss is spawned we do not want flip to continue 
			// too much until the boss has been killed			
			if (flip==2049&&boss)
				flip=2001;
			else if (flip==4049&&boss)
				flip=4001;	
				
			
			//based on the players location in the game a certain background
			// is loaded, then drawn
			if (flip<1500)
				sprite = loadImage("images/water.jpg");
			else if (flip<2500)
				sprite = loadImage("images/sand.png");
			else if (flip<4700)	
				sprite = loadImage("images/grass.jpg");
			else if (flip<6500)
				sprite = loadImage("images/dirt.jpg");
			else
				sprite = loadImage("images/floor.jpg");
				
			g.drawImage(sprite, 0, bgy, 800, 1200, this);
			
			//transitions are loaded to make the switch between backgrounds smoother
			if (flip>1300&&flip<1600)
			{
				transy+=3;
				sprite = loadImage("images/trans.jpg");
				g.drawImage(sprite, 0, transy, 800, 1200, this);
			}
			else if (flip==2300)
				transy=-800;
			else if (flip>2300&&flip<2600)
			{
				transy+=3;
				sprite = loadImage("images/trans1.jpg");
				g.drawImage(sprite, 0, transy, 800, 1200, this);
			}
			else if (flip==4500)
				transy=-800;
			else if (flip>4500&&flip<4800)
			{
				transy+=3;
				sprite = loadImage("images/trans2.jpg");
				g.drawImage(sprite, 0, transy, 800, 1200, this);
			}
			else if (flip==6300)
				transy=-800;
			else if (flip>6300&&flip<6600)
			{
				transy+=3;
				sprite = loadImage("images/trans3.jpg");
				g.drawImage(sprite, 0, transy, 800, 1200, this);
			}
			
			//clouds can be commented out to prevent lag
			//sprite = loadImage("images/clouds1.png");
			//g.drawImage(sprite, 0, cloudy, 800,600, this);
			
			//if the clouds have gone off the screen their y is reset 
			//so that they will appear again later	
			if (cloudy>1000)
				cloudy=-800;
				
			//this loops the background around so it doesnt scroll completely off the screen
			if (bgy>0)
				bgy=-600;
			
			//this calls the spawn method when it is time for a boss
			//to spawn, the other ships are also deactivated
			if (flip==2000||flip==4000||flip==8000)
			{
				for (int j=0;j<activedot;j++)
					d[j].active=false;
				spawn(0);
				flip++;	
			}

			
			//the further in the game the player is
			//the more ships there are
			else if (flip==1000)
				activedot=4;
			else if (flip==2200)
				activedot=5;
			else if (flip==4200)
				activedot=6;
					
			//this spawns a random powerup		
			if (flip%300==0)
			{
				pup.active=true;	
				pup.y=-75;
				tempx=MyLib.randomInt(15+1);
				if (tempx>11&&tempx<15)
					pup.type=1;
				else if (tempx==15)
					pup.type=2;
				else
					pup.type=0;	
			}
			
			//the powerup is drawn and scrolls down the screen
			if (pup.active)
			{
				pup.y+=8;
				if (pup.type==2)
					sprite = loadImage("images/life.png");
				else if (pup.type==1)
					sprite = loadImage("images/nuke.png");
				else
					sprite = loadImage("images/pup.png");
				g.drawImage(sprite, pup.x, pup.y, 60, 60, this);
			}
			if (pup.y>650)
				pup.active=false;
				
	

			
			//this creates a "sheild" effect underneath a player
			// that has just been hit so they know they are safe
			for (int c=0;c<playnum;c++)
			{
				if (p[c].inv>1)
				{
					g.setColor(Color.green);
					g.fillOval(p[c].x,p[c].y, 55, 55);
				}
			}
					
			//this massive for loop draws animates explosions based on their index
			// in the explosion object which indicates what image to use		
			for (int c=0;c<200;c++)
			{
				if (e[c].active)
				{	
					e[c].index++;
					if (e[c].index<1)
					{
						sprite = loadImage("images/explosion/9.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<2)
					{
						sprite = loadImage("images/explosion/8.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<3)
					{
						sprite = loadImage("images/explosion/7.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<4)
					{
						sprite = loadImage("images/explosion/6.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<5)
					{
						sprite = loadImage("images/explosion/5.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<6)
					{
						sprite = loadImage("images/explosion/4.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<7)
					{
						sprite = loadImage("images/explosion/3.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<8)
					{
						sprite = loadImage("images/explosion/2.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<9)
					{
						sprite = loadImage("images/explosion/1.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<10)
					{
						sprite = loadImage("images/explosion/2.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<11)
					{
						sprite = loadImage("images/explosion/3.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<12)
					{
						sprite = loadImage("images/explosion/4.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<13)
					{
						sprite = loadImage("images/explosion/5.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<14)
					{
						sprite = loadImage("images/explosion/6.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<15)
					{
						sprite = loadImage("images/explosion/7.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<16)
					{
						sprite = loadImage("images/explosion/8.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else if (e[c].index<17)
					{
						sprite = loadImage("images/explosion/9.png");
						g.drawImage(sprite, e[c].x, e[c].y, e[c].ysize, e[c].xsize, this);
					}
					else
						e[c].active=false;
				}
			}
						

			//the enemies bullets x and y increase based on their velocity
			for (int i=0;i<200;i++)
			{
				b[i].x+=b[i].xv;
				b[i].y+=b[i].yv;
			}
			
			
			for (int c=0;c<activedot;c++)
			{
				//if an enemy has been killed, spawn a new one
				if (d[c].active==false)
					spawn(c);	
				
				//this is used for bringing bosses onto the screen before
				//their strafing movement starts
				if (d[c].type>9&&d[c].x>100&&tempb==false)
						tempb=true;		
				if (d[c].type>9&&d[c].x>780-d[c].xsize||(d[c].x<20&&tempb))
					d[c].xv*=-1;
				
				// if an enemy has flown off the screen, kill it
				if (d[c].active&&d[c].y>650)
				{
					d[c].active=false;
				}
				
				//this checks to see if a player crashed into another ship
				//if so the ship and the player die, unless the ship is a boss
				for (int j=0;j<playnum;j++)
				{
					if (p[j].inv<1&&(d[c].active&&p[j].alive&&p[j].x>d[c].x-30&&p[j].x<d[c].x+d[c].xsize*0.6&&p[j].y+40>d[c].y&&p[j].y<d[c].y+d[c].ysize-20))
					{
						explode(p[j].x, p[j].y,75, 75);

						
						if (p[j].lives>0)
						{
							p[j].lives--;
							if (d[c].type<10)
								d[c].active=false;	
							p[j].inv=35;
							p[j].power=1;
							sound1.play();
							p[j].x=400;
							p[j].y=500;
							p[j].bomb=1;
							
						}
						else if (p[j].lives<1)
							p[j].alive=false;	
					}
				}			
				
				//this draws the different enemies, based on their type
				// and increases their x/y coords based on velocity
				if (d[c].active==true)
				{
					d[c].y+=d[c].yv;
					d[c].x+=d[c].xv;

					if (d[c].type==0)
						sprite = loadImage("images/fighter.png");
					else if (d[c].type==1)
						sprite = loadImage("images/destroyer.png");
					else if (d[c].type==2)
						sprite = loadImage("images/destroyer2.png");
					else if (d[c].type==3)
						sprite = loadImage("images/crab1.png");
					else if (d[c].type==4)
						sprite = loadImage("images/cruiser.png");			
					else if (d[c].type==10)
						sprite = loadImage("images/boss1.png");
					else if (d[c].type==11)
						sprite = loadImage("images/boss2.png");
					else if (d[c].type==12)
						sprite = loadImage("images/boss3.png");	
					
							

					g.drawImage(sprite, d[c].x, d[c].y, d[c].xsize, d[c].ysize, this);	
				}	
			}
			
			
			for (int c=0;c<playnum;c++)
			{
				//we lower the players shield duration
				p[c].inv--;
				
				//if the player passes over a powerup, it is absorbed accordingly
				if (pup.active&&p[c].alive&&p[c].x>pup.x-35&&p[c].x<pup.x+35&&p[c].y+35>pup.y&&p[c].y-35<pup.y)
				{
					if (pup.type==0)
						p[c].power+=1;
					else if (pup.type==1)
						p[c].bomb++;
					else 
						p[c].lives++;	
					
					pup.active=false;
					if (p[c].power>4)
						p[c].score+=1000;
				}
				
				//we draw the players
				if (c==0)
				{
					if(p[c].left)	
						sprite = loadImage("images/player1left.png");
					else if (p[c].right)
						sprite = loadImage("images/player1right.png");
					else
						sprite = loadImage("images/player1fin.png");	
				}
				else
				{
					if (p[c].left)	
						sprite = loadImage("images/player2left.png");
					else if (p[c].right)
						sprite = loadImage("images/player2right.png");
					else
						sprite = loadImage("images/player2fin.png");
				}	
				if (p[c].alive)
					g.drawImage(sprite, p[c].x, p[c].y, 55, 55, this);
					
				//the enemies bullets are drawn in
				for (int i=0;i<200;i++)
				{
					if (b[i].active)
					{	
						if (b[i].yv>0)
							sprite = loadImage("images/bullets/bluel.png");
						else
							sprite = loadImage("images/bullets/bluel2.png");
						g.drawImage(sprite, b[i].x,b[i].y, b[i].size, b[i].size*5, this);
						
					}
					//this checks to see if a player has been hit by a bullet
					//if so the player loses a life and is reset to default status
					//he is made temporarily invincible so he doesn't spawn on a bullet
					if (p[c].inv<1&&(b[i].active&&p[c].alive&&p[c].x-b[i].size<b[i].x&&p[c].x+50>b[i].x)&&(p[c].y-b[i].size<b[i].y&&p[c].y+50>b[i].y))				
					{
							explode(p[c].x, p[c].y,55, 55);
							if (p[c].lives>0)
							{
								p[c].lives--;
								b[i].active=false;	
								p[c].inv=35;
								p[c].bomb=1;
								p[c].power=1;
								sound1.play();
								p[c].x=400;
								p[c].y=500;
								p[c].boom=false;
							}
							else
								p[c].alive=false;
					}
				}
				
				//this checks to see if an enemy has been hit with a bullet
				//if so it takes damage, and is killed if it is out of hitpoints
				//if it was a boss, the game is set to continue on
				//bullets are also drawn in this for count	
				for (int i=0;i<50;i++)
				{
					p[c].b[i].y-=15;
					if (p[c].b[i].y<0)
						p[c].b[i].active=false;
					for (int j=0;j<activedot;j++)
					{
						if (p[c].b[i].active&&d[j].active&&(p[c].b[i].x+p[c].b[i].size>d[j].x&&p[c].b[i].x<d[j].x+d[j].xsize)&&(p[c].b[i].y+p[c].b[i].size>d[j].y-30&&p[c].b[i].y<d[j].y+d[j].ysize/2-p[c].b[i].size*2))
						{
							sprite = loadImage("images/explode.png");
							g.drawImage(sprite, p[c].b[i].x, p[c].b[i].y, 25, 25, this);
						
							
							p[c].b[i].active=false;
							d[j].life--;
							sound4.play();																
						}
						if (d[j].life<1&&d[j].active)
						{
							if (d[j].type>9)
							{
								boss=false;	
								if (d[j].type==10)
									flip=2050;
								else if (d[j].type==11)
									flip=4050;
								else if (d[j].type==12)
									flip=8050;	
								activedot=0;
								tempb=false;
							}
							d[j].active=false; 
							explode(d[j].x, d[j].y,d[j].xsize, d[j].ysize);
							if (d[j].type<10)
								p[c].score+=100*(d[j].type+1);
						}	
					}
					if (p[c].b[i].active)
					{
						
						sprite = loadImage("images/bullets/redl.png");
						g.drawImage(sprite, p[c].b[i].x,p[c].b[i].y, p[c].b[i].size, p[c].b[i].size*5,this);
					}
				}	
			}
		}
		
		//if the players are alive increase their score
		if (p[0].alive&&boss==false)
			p[0].score++;
		if (p[1].alive&&boss==false)
			p[1].score++;

		
		//output the score, lives, and bomb number to the players		
		g.setColor(Color.black);
		if (p[0].alive)
		{
			g.drawString("Player 1 Score:"+p[0].score,15,15);
			g.drawString("Player 1 Lives:"+p[0].lives,15,30);
			g.drawString("Player 1 Bombs:"+p[0].bomb,15,45);
		}
		if (p[1].alive)
		{
			g.drawString("Player 2 Score:"+p[1].score,650,15);
			g.drawString("Player 2 Lives:"+p[1].lives,650,30);
			g.drawString("Player 2 Bombs:"+p[1].bomb,650,45);
		}
		if (boss==false&&flip>8050)
		{
			g.drawString("Game Over",350,300);
		}
		if (boss==false&&flip>8125)
			System.exit(0);	
		else if (boss==false&&flip>8050)
		{
			g.drawString("Game Over",350,300);
		}	
		requestFocus();
	}
	
	
	
	
	//////////////////////action stuff//////////////////////////
	
	

	public void actionPerformed(ActionEvent e)
	{ 
		//this takes care of firing for the enemies
		//it fires in different patterns based on the enemy type
		//and timing in the game, after it has found a place
		//in the bullet queue it breaks the loop
		for (int c=0;c<activedot;c++)
		{
			tempx=MyLib.randomInt(1+1);
			tx=MyLib.randomInt(6);
			for (int j=0;j<200;j++)
			{
				if (d[c].type==0&d[c].active==true&&b[j].active==false&&flip%35==0)
				{	
						b[j].size=5;
						b[j].active=true;
						b[j].y=d[c].y+d[c].ysize/2;
						b[j].x=d[c].x+d[c].xsize/2;
						b[j].xv=0;
						b[j].yv=16;
						break;
				}
				else if (d[c].type==1&&d[c].active==true&&flip%40==0&&b[j].active==false)
				{
					b[j].active=true;
					b[j].x=d[c].x+d[c].xsize/2-7;
					b[j].y=d[c].y+d[c].ysize/2;
					b[j].xv=0;
					b[j].yv=15;
					b[j].size=15;
					break;
				}
				else if (d[c].type==2&&d[c].active==true&&flip%42==0&&b[j].active==false)
				{
					b[j].active=true;
					b[j].x=d[c].x+d[c].xsize/2;
					b[j].y=d[c].y+d[c].ysize/2;
					b[j].xv=15-MyLib.randomInt(30);
					b[j].yv=15;	
					b[j].size=8;
					break;
				}
				else if (d[c].y<600&&d[c].type==3&&d[c].active==true&&flip%43==0&&b[j].active==false)
				{
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-10;
							b[r].x=d[c].x+d[c].xsize/2-10;
							b[r].xv=0;
							b[r].yv=15;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-10;
							b[r].x=d[c].x+d[c].xsize/2+10;
							b[r].xv=0;
							b[r].yv=15;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-30;
							b[r].x=d[c].x+d[c].xsize/2-10;
							b[r].xv=0;
							b[r].yv=-15;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-30;
							b[r].x=d[c].x+d[c].xsize/2+10;
							b[r].xv=0;
							b[r].yv=-15;
							break;
						}
					}
					break;
				}
				else if (d[c].type==4&&d[c].active==true&&flip%43==0&&b[j].active==false)
				{
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2;
							b[r].x=d[c].x+d[c].xsize/2-20;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2;
							b[r].x=d[c].x+d[c].xsize/2+20;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-10;
							b[r].x=d[c].x+d[c].xsize/2-45;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-10;
							b[r].x=d[c].x+d[c].xsize/2+45;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					break;
				}
				else if (d[c].type==10&&d[c].active==true&&flip%15==0&&b[j].active==false)
				{
					b[j].active=true;
					b[j].x=d[c].x+d[c].xsize/2;
					b[j].y=d[c].y+d[c].ysize/2;
					b[j].xv=15-MyLib.randomInt(30);
					b[j].yv=15;	
					b[j].size=10;
					break;
				}
				else if (d[c].type==11&&d[c].active==true&&flip%20==0&&b[j].active==false)
				{
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2;
							b[r].x=d[c].x+d[c].xsize/2-45;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2;
							b[r].x=d[c].x+d[c].xsize/2+45;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-10;
							b[r].x=d[c].x+d[c].xsize/2-150;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=5;
							b[r].active=true;
							b[r].y=d[c].y+d[c].ysize/2-10;
							b[r].x=d[c].x+d[c].xsize/2+150;
							b[r].xv=0;
							b[r].yv=13;
							break;
						}
					}
					break;	
				}
				else if (d[c].type==12&&d[c].active==true&&flip%7==0&&b[j].active==false)
				{
					if (flip%14==0)
					{
						b[j].active=true;
						b[j].x=d[c].x+d[c].xsize/2-7;
						b[j].y=d[c].y+d[c].ysize/2;
						b[j].xv=0;
						b[j].yv=15;
						b[j].size=12;
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=10;
							b[r].active=true;
							b[r].y=d[c].y;
							b[r].x=d[c].x;
							b[r].xv=15-MyLib.randomInt(30);
							b[r].yv=15;
							break;
						}
					}
					for (int r=0;r<200;r++)
					{
						if (b[r].active==false)
						{
							b[r].size=10;
							b[r].active=true;
							b[r].y=d[c].y;
							b[r].x=d[c].x+d[c].xsize;
							b[r].xv=15-MyLib.randomInt(30);
							b[r].yv=15;
							break;
						}
					}
					break;
				}
			//if the bullet has flown off the screen get rid of it	
			if (b[j].y>650)
				b[j].active=false;
			}
		}
		
			
		for(int i=0;i<playnum;i++)
		{	
			//movement for the player, makes sure they dont go off the screen		
			if (p[i].alive==true)
			{		
				if (p[i].left==true&&p[i].x>10)
					p[i].x=p[i].x-10;
				else if(p[i].right==true&&p[i].x<750)
					p[i].x=p[i].x+10;
				if (p[i].up==true&&p[i].y>10)
					p[i].y=p[i].y-10;
				else if(p[i].down==true&&p[i].y<500)
					p[i].y=p[i].y+10;
			}
			//this takes care of launching bombs
			if (p[i].boom)
			{
				if (p[i].bomb>0)
				{
					explode(0, -100,800, 800);
					p[i].boom=false;
					p[i].bomb--;
					sound1.play();
					for (int r=0;r<activedot;r++)
						d[r].life-=25;
				}
				
			}
			
			//the player has pressed fire and lasers are created
			//based on the players powerups
			if (p[i].fire==true)
			{
				for(int r=1;r<=p[i].power;r++)
				{
					for (int c=0;c<50;c++)
					{
						if (p[i].b[c].active==false&&flip%10>3)
						{
							p[i].b[c].active=true;
							
							if (p[i].power==1)
							{
								p[i].b[c].x=p[i].x+25;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==2&&r==1)
							{
								p[i].b[c].x=p[i].x+16;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==2&&r==2)
							{
								p[i].b[c].x=p[i].x+32;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==3&&r==1)
							{
								p[i].b[c].x=p[i].x+15;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==3&&r==2)
							{
								p[i].b[c].x=p[i].x+25;
								p[i].b[c].y=p[i].y-20;
							}
							else if (p[i].power==3&&r==3)
							{
								p[i].b[c].x=p[i].x+35;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==1)
							{
								p[i].b[c].x=p[i].x+8;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==2)
							{
								p[i].b[c].x=p[i].x+16;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==3)
							{
								p[i].b[c].x=p[i].x+33;
								p[i].b[c].y=p[i].y-20;
							}
							else if (r==4)
							{
								p[i].b[c].x=p[i].x+42;
								p[i].b[c].y=p[i].y-20;
							}
							
							
							p[i].b[c].yv=-25;
							p[i].b[c].xv=0;	
							sound3.play();
							break;
						}
					}
				}
				p[i].fire=false;
			}
			
				
			}
					
		repaint();
	}
	
	
	/////////////////////////key stuff////////////////////////
	
	
	//this keeps track of what the user presses so they can
	//interact with the game
	public void keyPressed(KeyEvent e){
		if (e.getKeyChar() == 'a') {
			p[0].left=true;
			p[0].right=false;
		}
		if (e.getKeyChar() == 'd') {
			p[0].right=true;
			p[0].left=false;
		}
		if (e.getKeyChar() == 'w') {
			p[0].up=true;
			p[0].down=false;
		}
		if (e.getKeyChar() == 's') {
			p[0].down=true;
			p[0].up=false;
		}
		if (e.getKeyChar() == 'b'&&p[0].alive==true) {
			p[0].fire=true;
		}
		if (e.getKeyChar() == 'v'&&p[0].alive==true&&p[0].bomb>0) {
			p[0].boom=true;
		}
		
		if (e.getKeyChar() =='1') {
			p[1].left=true;
			p[1].right=false;
		}
		if (e.getKeyChar() == '3') {
			p[1].right=true;
			p[1].left=false;
		}
		if (e.getKeyChar() == '5') {
			p[1].up=true;
			p[1].down=false;
		}
		if (e.getKeyChar() == '2') {
			p[1].down=true;
			p[1].up=false;
		}
		if (e.getKeyChar() == ']'&&p[1].alive==true) {
			p[1].fire=true;
		}
		if (e.getKeyChar() == '['&&p[0].alive==true&&p[1].bomb>0) {
			p[1].boom=true;
		}


	}
	public void keyReleased(KeyEvent e){ 
		if (e.getKeyChar() == 'a') {
			p[0].left=false;
		}
		if (e.getKeyChar() == 'd') {
			p[0].right=false;
		}
		if (e.getKeyChar() == 'w') {
			p[0].up=false;
		}
		if (e.getKeyChar() == 's') {
			p[0].down=false;
		}
		
		if (e.getKeyChar() == '1') {
			p[1].left=false;
		}
		if (e.getKeyChar() == '3') {
			p[1].right=false;
		}
		if (e.getKeyChar() == '5') {
			p[1].up=false;
		}
		if (e.getKeyChar() == '2') {
			p[1].down=false; 
		}
		
		
	}
	public void keyTyped(KeyEvent e)
	{ 
	}
}
