//This object governs the behaviour of the different enemies in our game
class Enemy
{
	private int enemy;
	private int enemx;
	private int height;
	private int width;
	private int initx;
	private int inity;
	private int health;
	private String image;
	private String name;
	private boolean alive = true;
	private int actionnum = 0;
	private boolean activate = false;
	private int deathanim = 1;
	private int dmgx[];
	private int dmgy[];
	private int dmgh[];
	private int dmgw[];
	private int dmgamount[];
	private int dmganim[];
	private String dmgpic[];
	private int dmgzones;
	private int animnum = 1;
	private int points = 0;
	int target = 0;
	RandomNum randomizer = new RandomNum();
	//the constructor of this object, sets some of the specs for the enemies
	//some specific to each enemy and some not.
	public Enemy(int startx, int starty, String n){
		name = n;
		enemx = startx;
		enemy = starty;
		initx = startx;
		inity = starty;
		if (name.equals("oscar"))
		{
			height = 100;
			width = 50;
			dmgzones = 1;
			dmgamount = new int[dmgzones];
			dmgamount[0] = 35;
			image = "fagnemy1.png";
			health = 1;
		}
		if (name.equals("lenny"))
		{
			height = 100;
			width = 50;
			dmgzones = 1;
			dmgamount = new int[dmgzones];
			dmgamount[0] = 25;
			image = "lennyright1.png";
			health = 1;
		}
		if (name.equals("steve"))
		{
			height = 100;
			width = 50;
			dmgzones = 1;
			dmgamount = new int[dmgzones];
			dmgamount[0] = 5;
			image = "MR1.png";
			health = 1;
		}
		if (name.equals("tank"))
		{
			height = 550;
			width = 600;
			dmgzones = 1;
			dmgamount = new int[dmgzones];
			dmgamount[0] = 100;
			image = "destroyer1.png";
			health = 99999;
		}
		if (name.equals("freddy"))
		{
			height = 100;
			width = 100;
			dmgzones = 3;
			dmgamount = new int[dmgzones];
			dmgamount[0] = 12;
			dmgamount[1] = 3;
			dmgamount[2] = 0;
			image = "atk1";
			health = 50;
		}
		if (name.equals("hat"))
		{
			height = 150;
			width = 100;
			dmgzones = 3;
			dmgamount = new int[dmgzones];
			dmgamount[0] = 10;
			dmgamount[1] = 20;
			dmgamount[2] = 5;
			image = "hatleft1.png";
			health = 50;
		}
		dmgx = new int [dmgzones];
		dmgy = new int [dmgzones];
		dmgh = new int [dmgzones];
		dmgw = new int [dmgzones];
		dmganim = new int [dmgzones];
		dmgpic = new String [dmgzones];
		for (int c = 0; c < dmgzones; c++)
		{
			dmgx[c] = 0;
			dmgy[c] = 0;
			dmgh[c] = 0;
			dmgw[c] = 0;	
			dmganim[c] = 1;
			dmgpic[c] = "blank.png";
		}
	}
	//a number of methods to return information about the enemies to gamepanel
	public int getPoints(){
		return(points);
	}
	public int getDmgX(int slot){
		return(dmgx[slot]);
	}
	public int getDmgY(int slot){
		return(dmgy[slot]);
	}
	public int getDmgH(int slot){
		return(dmgh[slot]);
	}
	public int getDmgW(int slot){
		return(dmgw[slot]);
	}
	public int getDmgAmount(int slot){
		return(dmgamount[slot]);
	}
	public int getDmgZones(){
		return(dmgzones);
	}
	public String getDmgPic(int slot){
		return(dmgpic[slot]);
	}
	public int getX() {
		return(enemx);
	}
	public int getY() {
		return(enemy);
	}
	public int getHeight() {
		return(height);
	}
	public int getWidth() {
		return(width);
	}
	public String getImage() {
		return(image);
	}
	public boolean isAlive() {
		return(alive);
	}
	//reduces the health of the enemy and probably kills it
	//as well as removes all the damage the enemy does as well
	public void kill() {
		health = health - 1;
		if (health == 0)
		{
			if (name.equals("oscar"))
				points = 50;
			if (name.equals("lenny"))
				points = 50;
			if (name.equals("steve"))
				points = 75;
			if (name.equals("freddy"))
				points = 1000;
			if (name.equals("hat"))
				points = 1000;
			alive = false;
			for (int c = 0; c < dmgzones; c++)
			{
				dmgx[c] = 0;
				dmgy[c] = 0;
				dmgh[c] = 0;
				dmgw[c] = 0;
				dmganim[c] = 1;
			}
		}
	}
	//brings an enemy back to life
	//and restores a lot of it's specs
	public void revive() {
		alive = true;
		activate = false;
		actionnum = 0;
		deathanim = 1;
		animnum = 1;
		enemx = initx;
		enemy = inity;
		if (name.equals("oscar"))
		{
			height = 100;
			width = 50;
			dmgamount[0] = 35;
			image = "fagnemy1.png";
			health = 1;
		}
		if (name.equals("lenny"))
		{
			height = 100;
			width = 50;
			dmgamount[0] = 10;
			image = "lennyright1.png";
			health = 1;
		}
		if (name.equals("steve"))
		{
			height = 100;
			width = 50;
			dmgamount[0] = 5;
			image = "MR1.png";
			health = 1;
		}
		if (name.equals("tank"))
		{
			height = 550;
			width = 600;
			dmgamount[0] = 100;
			image = "destroyer1.png";
			health = 99999;
		}
		if (name.equals("freddy"))
		{
			height = 100;
			width = 100;
			dmgamount[0] = 12;
			dmgamount[1] = 3;
			dmgamount[2] = 0;
			image = "atk1.png";
			health = 50;
		}
		if (name.equals("hat"))
		{
			height = 150;
			width = 100;
			dmgamount[0] = 10;
			dmgamount[1] = 20;
			dmgamount[2] = 5;
			image = "hatleft1.png";
			health = 50;
		}
		for (int c = 0; c < dmgzones; c++)
		{
			dmgx[c] = 0;
			dmgy[c] = 0;
			dmgh[c] = 0;
			dmgw[c] = 0;	
		}
	}
	//activates the enemy so that it begins it's behaviour
	public void activate() {
		if (activate == false)
			actionnum = 0;
		activate = true;
	}
	//this large chunk of code governs the behaviour of the various enemies
	//depending on what time of enemy the enemy is it can behave in a very different way.
	//uses a variable called actionnum to govern where in it's pattern an enemy is.
	public void behave(int playerx, int playery) {
		if (activate)
		{
			if (name.equals("oscar"))
			{
				if (alive == false)
				{
					image = "fagnemy" + deathanim + ".png";
					if (deathanim < 11)
					{
						deathanim++;
					}
				}
				else
				{
					if (actionnum == 0)
					{
						dmgamount[0] = 0;
						dmgx[0] = enemx - 400;
						dmgy[0] = enemy;
						dmgh[0] = 50;
						dmgw[0] = 400;
					}
					if (actionnum == 10)
					{
						height = 100;
						dmgamount[0] = 35;
						dmgpic[0] = "shotleft1.png";
					}
					if (actionnum == 11)
					{
						dmgamount[0] = 0;
						dmgpic[0] = "shotleft2.png";
					}
					if (actionnum == 12)
						dmgpic[0] = "shotleft3.png";
					if (actionnum == 13)
						dmgpic[0] = "shotleft4.png";
					if (actionnum == 14)
						dmgpic[0] = "shotleft5.png";
					if (actionnum == 15)
						dmgpic[0] = "blank.png";
					if (actionnum == 20)
					{
						enemy = enemy + 50;
						height = 50;
						image = "fagnemysquat.png";
					}
					if (actionnum == 70)
					{
						enemy = enemy - 50;
						height = 100;
						image = "fagnemy1.png";
					}
				}
			}
			if (name.equals("lenny"))
			{
				if (alive == false)
				{
					image = "death" + deathanim + ".png";
					if (deathanim < 23)
					{
						deathanim++;
					}
				}
				else
				{
					animnum++;
					if (animnum == 10)
						animnum = 1;
					if (actionnum <= 50)
					{
						dmgx[0] = enemx - 400;
						dmgy[0] = enemy;
						dmgh[0] = 50;
						dmgw[0] = 400;
						if (playerx < enemx)
						{
							dmgpic[0] = "shotleft" + ((actionnum%5) + 1) +".png";
						}
						else
						{
							dmgpic[0] = "blank.png";
						}
						if (actionnum%5 == 0)
							dmgamount[0] = 5;
						else
							dmgamount[0] = 0;
						image = "lennyleft" + animnum + ".png";
						enemx = enemx - 1;
					}
					if (actionnum > 50)
					{
						dmgx[0] = enemx + 50;
						dmgy[0] = enemy;
						dmgh[0] = 50;
						dmgw[0] = 400;
						if (playerx > enemx + 50)
						{
							dmgpic[0] = "shotright" + ((actionnum%5) + 1) +".png";
						}
						else
						{
							dmgpic[0] = "blank.png";
						}
						if (actionnum%5 == 0)
							dmgamount[0] = 5;
						else
							dmgamount[0] = 0;
						image = "lennyright" + animnum + ".png";
						enemx = enemx + 1;
					}		
				}
			}
			if (name.equals("steve"))
			{
				if (alive == false)
				{
					image = "deathmr" + deathanim + ".png";
					if (deathanim < 8)
					{
						deathanim++;
					}
				}
				else
				{
					if (actionnum == 0)
						enemx = enemx - 800;
					animnum++;
					if (animnum == 7)
						animnum = 1;
					image = "MR" + animnum + ".png";
					enemx = enemx - 1;
					enemx = enemx + 20;
					dmgx[0] = enemx;
					dmgy[0] = enemy;
					dmgh[0] = height;
					dmgw[0] = width;		
				}
			}
			if (name.equals("tank"))
			{
				enemx = enemx + 14;
				if (actionnum == 0)
					enemx = enemx - 800;
				animnum++;
				if (animnum == 5)
					animnum = 1;
				image = "destroyer" + animnum + ".png";
				dmgx[0] = enemx;
				dmgy[0] = enemy;
				dmgh[0] = height;
				dmgw[0] = width;
			}
			if (name.equals("freddy"))
			{
				if (alive == false)
				{
					image = "ded" + deathanim + ".png";
					if (deathanim < 23)
					{
						deathanim++;
					}
				}
				else
				{
					if (actionnum == 1)
					{
						enemy = 150;
					}
					if (actionnum == 25)
					{
						enemy = 300;
						if (target == 0)
						{
							dmgx[1] = 200;
							dmgy[1] = 150;
							dmgh[1] = 100;
							dmgw[1] = 100;	
						}
						if (target == 1)
						{
							dmgx[1] = 150;
							dmgy[1] = 300;
							dmgh[1] = 100;
							dmgw[1] = 200;	
						}
						if (target == 2)
						{
							dmgx[1] = 50;
							dmgy[1] = 450;
							dmgh[1] = 100;
							dmgw[1] = 300;	
						}
					}
					if (actionnum == 50)
					{
						enemy = 450;
					}
					if (actionnum == 75)
					{
						enemy = 300;
						if (target == 0)
						{
							dmgx[1] = 200;
							dmgy[1] = 150;
							dmgh[1] = 100;
							dmgw[1] = 100;	
						}
						if (target == 1)
						{
							dmgx[1] = 150;
							dmgy[1] = 300;
							dmgh[1] = 100;
							dmgw[1] = 200;	
						}
						if (target == 2)
						{
							dmgx[1] = 50;
							dmgy[1] = 450;
							dmgh[1] = 100;
							dmgw[1] = 300;	
						}
					}
					dmgx[0] = 350;
					dmgy[0] = 0;
					dmgh[0] = 550;
					dmgw[0] = 100;
					image = "atk1.png";
					for (int c = 0; c < 21; c++)
					{
						if (c == actionnum ||
							(50+c) == actionnum)
						{
							image = "atk" + c + ".png";
							break;
						}
					}
					if (actionnum == 15)
					{
						dmgx[2] = 450;
						dmgy[2] = 150;
					}
					if (actionnum == 65)
					{
						dmgx[2] = 450;
						dmgy[2] = 450;
					}
					if (actionnum == 15 ||
						actionnum == 65)
					{
						target = randomizer.getNum(3);
						while (target == (dmgy[1]/150) - 1)
							target = randomizer.getNum(3);
						dmgh[2] = 50;
						dmgw[2] = 50;
						dmgpic[2] = "bottle1.png";
					}
					if (actionnum > 15 && actionnum< 25)
					{	
						dmgx[2] = dmgx[2] - 20;
						dmgpic[2] = "bottle" + ((actionnum - 15)%4 + 1) + ".png";
						if (target == 1)
							dmgy[2] = dmgy[2] + 10;
						if (target == 2)
							dmgy[2] = dmgy[2] + 20; 
					}
					if (actionnum > 65 && actionnum < 75)
					{	
						dmgx[2] = dmgx[2] - 20;
						dmgpic[2] = "bottle" + ((actionnum - 65)%4 + 1) + ".png";
						if (target == 1)
							dmgy[2] = dmgy[2] - 10;
						if (target == 0)
							dmgy[2] = dmgy[2] - 20;  
					}
					if (actionnum == 75 || actionnum == 25)
					{
						dmgpic[2] = "blank.png";
					}
					if (dmganim[1] < 6)
						dmganim[1]++;
					if (dmganim[1] == 6)
						dmganim[1] = 1;
					dmgpic[1] = "fire" + dmganim[1] + ".png";
					if (dmganim[0] < 6)
						dmganim[0]++;
					if (dmganim[0] == 6)
						dmganim[0] = 1;
					dmgpic[0] = "flamepillar" + dmganim[0] + ".png";		
				}
			}
			if (name.equals("hat"))
			{
				if (alive == false)
				{
					image = "hatdeath" + deathanim + ".png";
					if (deathanim < 18)
					{
						deathanim++;
					}
				}
				else
				{
					animnum++;
					if (animnum == 11)
						animnum = 1;
					dmgx[1] = 700;
					dmgy[1] = 0;
					dmgh[1] = 400;
					dmgw[1] = 50;
					dmgx[2] = enemx;
					dmgy[2] = enemy;
					dmgh[2] = height;
					dmgw[2] = width;
					if (dmganim[1] < 6)
						dmganim[1]++;
					if (dmganim[1] == 6)
						dmganim[1] = 1;
					dmgpic[1] = "flamepillar" + dmganim[1] + ".png";
				/*	if (enemx == 325)
					{
						if (playerx < enemx)
							target = 0;
						if (playerx > enemx + width)
							target = 1; 
					} */
					if (enemx == 150 && target == 0)
						target = 1;
					if (enemx == 500 && target == 1)
						target = 0;
					if (target == 0)
					{
						dmgx[0] = enemx - 400;
						dmgy[0] = enemy + 30;
						dmgh[0] = 50;
						dmgw[0] = 400;
						if (playerx < enemx)
						{
							dmgpic[0] = "shotleft" + ((actionnum%5) + 1) +".png";
						}
						else
						{
							dmgpic[0] = "blank.png";
						}
						if (actionnum%5 == 0)
							dmgamount[0] = 20;
						else
							dmgamount[0] = 0;
						image = "hatleft" + animnum + ".png";
						enemx = enemx - 5;
					}
					if (target == 1)
					{
						dmgx[0] = enemx + 100;
						dmgy[0] = enemy + 30;
						dmgh[0] = 50;
						dmgw[0] = 400;
						if (playerx > enemx + 50)
						{
							dmgpic[0] = "shotright" + ((actionnum%5) + 1) +".png";
						}
						else
						{
							dmgpic[0] = "blank.png";
						}
						if (actionnum%5 == 0)
							dmgamount[0] = 20;
						else
							dmgamount[0] = 0;
						image = "hatright" + animnum + ".png";
						enemx = enemx + 5;
					}		
				}
			}
		}
		actionnum++;
		if (actionnum > 100)
			actionnum = 1;
	}
}