import java.io.*;

//an object used to grab the level from a text file.
//can be reused to load different levels
class LevelLoad
{
	private char tilemap[][];
	private int l;
	private int enemyx[];
	private int enemyy[]; 
	private int playerx;
	private int playery;
	private String enemtype[];
	private int enemcount;
	public LevelLoad()
	{
	}
	//The method that takes the filename of a text file and returns the data
	public void loadLevel (String filename)  {
		//this first chunk reads the contents of the text file to an array of strings
		String line[] = new String[12];
		try
		{
			BufferedReader reader = new BufferedReader(new FileReader(filename));
			for (int c = 0; c < 12; c++){
				try
				{
					line[c] = reader.readLine();
				}
				catch(IOException e)
				{
					System.out.println("Bad Level File");
				}
			}
			reader.close();
		}
		catch(IOException e)
		{
			System.out.println("File Input Error");
		}
		//this next part converts the array of strings to a 2d array of characters
		tilemap = new char [line[0].length()][12]; 
		l = line[0].length();
		for (int c1 = 0; c1 < 12; c1++){
			char tempholder[] = line[c1].toCharArray();
			for (int c2 = 0; c2 < line[0].length(); c2++)
				tilemap[c2][c1] = tempholder[c2];
		}
		//this part checks to see how many enemies are on the map so that
		//arrays of that size can be made to hold the data
		enemcount = 0;
		for (int xc = 0; xc < line[0].length(); xc++)
		{
			for (int yc = 0; yc < 12; yc++)
			{
				if (tilemap[xc][yc] == 'O')
					enemcount++;
				else if (tilemap[xc][yc] == 'L')
					enemcount++;
				else if (tilemap[xc][yc] == 'S')
					enemcount++;
				else if (tilemap[xc][yc] == 'F')
					enemcount++;
				else if (tilemap[xc][yc] == 'H')
					enemcount++;
				else if (tilemap[xc][yc] == 'T')
					enemcount++;
			}
		}
		enemyx = new int[enemcount];
		enemyy = new int[enemcount];
		enemtype = new String[enemcount];
		//this next section takes the information of the enemies
		//and replaces their indicators with blank space
		//so that they do not effect the physics.
		//This also takes the player's starting position.
		int enemslot = 0;
		for (int xc = 0; xc < line[0].length(); xc++)
		{
			for (int yc = 0; yc < 12; yc++)
			{
				if (tilemap[xc][yc] == 'O')
				{
					tilemap[xc][yc] = '0';
					enemyx[enemslot] = xc * 50;
					enemyy[enemslot] = yc * 50;
					enemtype[enemslot] = "Oscar";
					enemslot ++;
				}
				else if (tilemap[xc][yc] == 'L')
				{
					tilemap[xc][yc] = '0';
					enemyx[enemslot] = xc * 50;
					enemyy[enemslot] = yc * 50;
					enemtype[enemslot] = "Lenny";
					enemslot ++;
				}
				else if (tilemap[xc][yc] == 'S')
				{
					tilemap[xc][yc] = '0';
					enemyx[enemslot] = xc * 50;
					enemyy[enemslot] = yc * 50;
					enemtype[enemslot] = "Steve";
					enemslot ++;
				}
				else if (tilemap[xc][yc] == 'F')
				{
					tilemap[xc][yc] = '0';
					enemyx[enemslot] = xc * 50;
					enemyy[enemslot] = yc * 50;
					enemtype[enemslot] = "Freddy";
					enemslot ++;
				}
				else if (tilemap[xc][yc] =='H')
				{
					tilemap[xc][yc] = '0';
					enemyx[enemslot] = xc * 50;
					enemyy[enemslot] = yc * 50;
					enemtype[enemslot] = "Hat";
					enemslot ++;
				}
				else if (tilemap[xc][yc] =='T')
				{
					tilemap[xc][yc] = '0';
					enemyx[enemslot] = xc * 50;
					enemyy[enemslot] = yc * 50;
					enemtype[enemslot] = "Tank";
					enemslot ++;
				}
				else if (tilemap[xc][yc] == 'P')
				{
					playerx = xc * 50;
					playery = yc * 50 + 49;
					tilemap[xc][yc] = '0';
				}
			}
		}	
	}
	//now there are a number of methods to return
	//the information to gamepanel
	public char[][] getMap() {
		return(tilemap);
	}
	public int getLength() {
		return(l);
	}
	public int getEnemyNum() {
		return(enemcount);
	}
	public int getEnemyX(int slot) {
		return(enemyx[slot]);
	}
	public int getEnemyY(int slot) {
		return(enemyy[slot]);
	}
	public String getEnemyType(int slot){
		return(enemtype[slot]);
	}
	public int getPlayerX() {
		return(playerx);
	}
	public int getPlayerY() {
		return(playery);
	}
}