import java.io.*;
import javax.swing.*;
import javax.sound.sampled.AudioFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

import com.brackeen.javagamebook.sound.*;
import com.brackeen.javagamebook.test.GameCore;

class PlaySound
{
	private static final AudioFormat PLAYBACK_FORMAT = new AudioFormat(44100, 16, 1, true, false);
	private SoundManager soundManager;
   	private Sound s;
   	private InputStream lastloopingSound;
   	private boolean p;
	
	public PlaySound(String fileLoc)
	{
        soundManager = new SoundManager(PLAYBACK_FORMAT);
        s = soundManager.getSound(fileLoc);
        p = false;
	}
	
	public void play()
	{		
   		if (p)
   		{
   			soundManager.setPaused(false);
   			p = false;
   		}
   		else 
   		{
   			soundManager.play(s);
		}
	}
	
	public void loop()
	{
		soundManager.play(s,null,true);
	}
	
	public void stop()
	{
		soundManager.setPaused(true);
		p=true;
	}
	
	public void close()
	{
		soundManager.close();
	}
	
	
}